/*
 * 	sample4.t				version 1.0
 *	by Kevin Forchione		( Lysseus@msn.com )
 *	Copyright (c) 1999. 	All Rights Reserved.
 *
 *  SAMPLE DEMONSTRATION GAME FOR SENSE.T
 *
 *  This file demonstrates the use of sense.t accessibility rules to
 *  solve certain containment puzzles, such as distant objects, or very
 *  high shelves, and the redirection of action when throwing objects.
 *
 *  This file requires HTML TADS 2.5.1 or later.
 *
 *  You may modify and use this file in any way you want, provided that
 *	if you redistribute modified copies of this file in source form, the
 *  copies must include the original copyright notice (including this
 *  paragraph), and must be clearly marked as modified from the original
 *  version.
 *
 *------------------------------------------------------------------------------
 *		Revision History
 *------------------------------------------------------------------------------
 *		18-Jan-00:	Creation.
 *      07-Apr-00:  modified to use new permeable class and implement
 *                  new definition of reachability.
 */


/* use the HTML status line and prompts */
#define USE_HTML_STATUS
#define USE_HTML_PROMPT

/* We Must define USE_CONTAINMENT to facilitate the cage */
#define USE_CONTAINMENT

/* include the standard TADS libraries */
#include <adv.t>
#include <std.t>
#include <sense.t>

#pragma C+

replace commonInit: function
{
    "\H+";
}

greatHall: darkroom
    sdesc = "Great Hall"
    ldesc = "This is a vast hall. You can barely see the other side. "
;

startroom: permeable
    location = greatHall
    noun = 'cage'
    isenterable = true
    isopen = nil
    sdesc = "cage"
    insideDesc = "The inside of the cage is cramped."
;

box: openable
    location = startroom
    noun = 'box'
    sdesc = "box"
;

runningShoe: clothingItem
    location = Me
    noun = 'shoe'
    adjective = 'running'
    isworn = true
    bulk = 1
    sdesc = "running shoe"
;

horseShoe: item
    location = cupboard
    noun = 'shoe'
    adjective = 'horse'
    sdesc = "horse shoe"
;

beachBall: item
    location = startroom
    noun = 'ball'
    adjective = 'beach'
    bulk = 3
    sdesc = "beach ball"
;

wardrobe: fixeditem, surface
    location = greatHall
    noun = 'wardrobe'
    sdesc = "wardrobe"
    /*
     *  This method is used to block the actor from putting things on
     *  the wardrobe itself.
     */
    passToObject(plist, filter) = {
        if (filter == &access_touchable
        && command.verbPtr == putVerb)
            return nil;
        pass passToObject;
    }
    /*
     *  This method prevents the actor from doing anything with 
     *  wardrobe contents other than inspecting them and throwing
     *  objects at them.
     */
    passToContents(plist, filter) = {
        if (filter == &access_touchable) 
            return nil;
        pass passToContents;
    }
    cantTouch(vantage, target) = {
        if (getAccessfailed(target, GAF_PASSTO_METHOD) == &passToContents)
            "\^<<target.thedesc>> is too high up for you to reach. ";
        else if (getAccessfailed(target, GAF_PASSTO_METHOD) == &passToObject)
            "\^<<self.thedesc>> is too tall for %you% to do that. ";
        else pass cantReach;
    }
;

cupboard: fixeditem, transparentItem
    location = wardrobe
    noun = 'cupboard'
    adjective = 'sealed' 'glass'
    isopen = nil
    sdesc = "sealed glass cupboard"
    ioThrowAt(actor, dobj) =
    {
        "With a thud <<dobj.thedesc>> bounces off <<self.thedesc>>,
        landing harmlessly on <<self.location.thedesc>>. ";
        dobj.moveInto(self.location);
    }
;

smallLight: lightsource
    location = cupboard
    noun = 'light'
    adjective = 'small'
    sdesc = "small light"
    islit = true
;
